import { pipe, assocPath, dissocPath } from 'ramda';
import { specificationObj } from '@swagger-api/apidom-ns-json-schema-draft-7';
import JSONSchemaVisitor from "./visitors/json-schema/index.mjs";
import JSONSchema$vocabularyVisitor from "./visitors/json-schema/$vocabularyVisitor.mjs";
import JSONSchema$refVisitor from "./visitors/json-schema/$refVisitor.mjs";
import JSONSchema$defsVisitor from "./visitors/json-schema/$defsVisitor.mjs";
import JSONSchemaAllOfVisitor from "./visitors/json-schema/AllOfVisitor.mjs";
import JSONSchemaAnyOfVisitor from "./visitors/json-schema/AnyOfVisitor.mjs";
import JSONSchemaOneOfVisitor from "./visitors/json-schema/OneOfVisitor.mjs";
import JSONSchemaDependentSchemasVisitor from "./visitors/json-schema/DependentSchemasVisitor.mjs";
import JSONSchemaItemsVisitor from "./visitors/json-schema/ItemsVisitor.mjs";
import JSONSchemaPropertiesVisitor from "./visitors/json-schema/PropertiesVisitor.mjs";
import JSONSchemaPatternPropertiesVisitor from "./visitors/json-schema/PatternPropertiesVisitor.mjs";
import JSONSchemaDependentRequiredVisitor from "./visitors/json-schema/DependentRequiredVisitor.mjs";
import JSONSchemaLinkDescriptionVisitor from "./visitors/json-schema/link-description/index.mjs";
const specification = pipe(
// JSON Schema object modifications
assocPath(['visitors', 'document', 'objects', 'JSONSchema', '$visitor'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', '$vocabulary'], JSONSchema$vocabularyVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', '$anchor'], specificationObj.visitors.value), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', '$recursiveAnchor'], specificationObj.visitors.value), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', '$recursiveRef'], specificationObj.visitors.value), dissocPath(['visitors', 'document', 'objects', 'JSONReference', '$visitor']), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', '$ref'], JSONSchema$refVisitor), dissocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'definitions']), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', '$defs'], JSONSchema$defsVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'allOf'], JSONSchemaAllOfVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'anyOf'], JSONSchemaAnyOfVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'oneOf'], JSONSchemaOneOfVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'not'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'if'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'then'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'else'], JSONSchemaVisitor), dissocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'dependencies']), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'dependentSchemas'], JSONSchemaDependentSchemasVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'items'], JSONSchemaItemsVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'contains'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'properties'], JSONSchemaPropertiesVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'patternProperties'], JSONSchemaPatternPropertiesVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'additionalProperties'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'additionalItems'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'propertyNames'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'unevaluatedItems'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'unevaluatedProperties'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'maxContains'], specificationObj.visitors.value), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'minContains'], specificationObj.visitors.value), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'dependentRequired'], JSONSchemaDependentRequiredVisitor), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'deprecated'], specificationObj.visitors.value), assocPath(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'contentSchema'], JSONSchemaVisitor),
// Link Description object modifications
assocPath(['visitors', 'document', 'objects', 'LinkDescription', '$visitor'], JSONSchemaLinkDescriptionVisitor), assocPath(['visitors', 'document', 'objects', 'LinkDescription', 'fixedFields', 'targetSchema'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'LinkDescription', 'fixedFields', 'hrefSchema'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'LinkDescription', 'fixedFields', 'headerSchema'], JSONSchemaVisitor), assocPath(['visitors', 'document', 'objects', 'LinkDescription', 'fixedFields', 'submissionSchema'], JSONSchemaVisitor))(specificationObj);
export default specification;