# @swagger-api/apidom-parser-adapter-openapi-json-3-0

`@swagger-api/apidom-parser-adapter-openapi-json-3-0` is a parser adapter for the [OpenAPI 3.0.x specification](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.4.md) in [JSON format](https://www.json.org/json-en.html).
Under the hood this adapter uses [apidom-parser-adapter-json](https://github.com/swagger-api/apidom/tree/main/packages/apidom-parser-adapter-json)
to parse a source string into generic ApiDOM in [base ApiDOM namespace](https://github.com/swagger-api/apidom/tree/main/packages/apidom#base-namespace)
which is then refracted with [OpenAPI 3.0.x Refractors](https://github.com/swagger-api/apidom/tree/main/packages/apidom-ns-openapi-3-0#refractors).

## Installation

After [prerequisites](https://github.com/swagger-api/apidom/blob/main/README.md#prerequisites) for installing this package are satisfied, you can install it
via [npm CLI](https://docs.npmjs.com/cli) by running the following command:

```sh
 $ npm install @swagger-api/apidom-parser-adapter-openapi-json-3-0
```

## Parser adapter API

This parser adapter is fully compatible with parser adapter interface required by [@swagger-api/apidom-parser](https://github.com/swagger-api/apidom/tree/main/packages/apidom-parser#mounting-parser-adapters)
and implements all required properties.

### mediaTypes

Defines list of media types that this parser adapter recognizes.

```js
[
  'application/vnd.oai.openapi;version=3.0.0',
  'application/vnd.oai.openapi+json;version=3.0.0',
  'application/vnd.oai.openapi;version=3.0.1',
  'application/vnd.oai.openapi+json;version=3.0.1',
  'application/vnd.oai.openapi;version=3.0.2',
  'application/vnd.oai.openapi+json;version=3.0.2',
  'application/vnd.oai.openapi;version=3.0.3',
  'application/vnd.oai.openapi+json;version=3.0.3',
  'application/vnd.oai.openapi;version=3.0.4',
  'application/vnd.oai.openapi+json;version=3.0.4',
]
```

### detect

[Detection](https://github.com/swagger-api/apidom/blob/main/packages/apidom-parser-adapter-openapi-json-3-0/src/adapter.ts#L13) is based on a regular expression matching required OpenAPI 3.0.x specification symbols in JSON format.

### namespace

This adapter exposes an instance of [OpenAPI 3.0.x ApiDOM namespace](https://github.com/swagger-api/apidom/tree/main/packages/apidom-ns-openapi-3-0#openapi-30x-namespace).

### parse

`parse` function consumes various options as a second argument. Here is a list of these options:

Option | Type | Default | Description
--- | --- | --- | ---
<a name="specObj"></a>`specObj` | `Object` | [Specification Object](https://github.com/swagger-api/apidom/blob/main/packages/apidom-ns-openapi-3-0/src/refractor/specification.ts) | This specification object drives the JSON AST transformation to OpenAPI 3.0.x ApiDOM namespace.
<a name="sourceMap"></a>`sourceMap` | `Boolean` | `false` | Indicate whether to generate source maps.
<a name="refractorOpts"></a>`refractorOpts` | `Object` | `{}` | Refractor options are [passed to refractors](https://github.com/swagger-api/apidom/tree/main/packages/apidom-ns-openapi-3-0#refractor-plugins) during refracting phase.

All unrecognized arbitrary options will be ignored.

## Usage

This parser adapter can be used directly or indirectly via [@swagger-api/apidom-parser](https://github.com/swagger-api/apidom/tree/main/packages/apidom-parser).

### Direct usage

During direct usage you don't need to provide `mediaType` as the `parse` function is already pre-bound
with [supported media types](#mediatypes).

```js
import { parse, detect } from '@swagger-api/apidom-parser-adapter-openapi-json-3-0';

// detecting
await detect('{"openapi": "3.0.4"}'); // => true
await detect('test'); // => false

// parsing
const parseResult = await parse('{"openapi": "3.0.4"}', { sourceMap: true });
```

### Indirect usage

You can omit the `mediaType` option here, but please read [Word on detect vs mediaTypes](https://github.com/swagger-api/apidom/tree/main/packages/apidom-parser#word-on-detect-vs-mediatypes) before you do so.

```js
import ApiDOMParser from '@swagger-api/apidom-parser';
import * as openApiJsonAdapter from '@swagger-api/apidom-parser-adapter-openapi-json-3-0';

const parser = new ApiDOMParser();

parser.use(openApiJsonAdapter);

const parseResult = await parser.parse('{"openapi": "3.0.4"}', { mediaType: openApiJsonAdapter.mediaTypes.latest('json') });
```
