"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault").default;
exports.__esModule = true;
exports.parse = exports.namespace = exports.mediaTypes = exports.detect = void 0;
var _node = _interopRequireDefault(require("./lexical-analysis/node.cjs"));
exports.lexicalAnalysis = _node.default;
var _index = _interopRequireDefault(require("./syntactic-analysis/indirect/index.cjs"));
exports.syntacticAnalysis = _index.default;
var _adapter = require("./adapter.cjs");
exports.mediaTypes = _adapter.mediaTypes;
exports.namespace = _adapter.namespace;
/**
 * @public
 */
const detect = async source => {
  try {
    const cst = await (0, _node.default)(source);
    return !cst.rootNode.isError;
  } catch {
    return false;
  }
};

/**
 * @public
 */

/**
 * @public
 */
exports.detect = detect;
/**
 * @public
 */
const parse = async (source, {
  sourceMap = false
} = {}) => {
  const cst = await (0, _node.default)(source);
  return (0, _index.default)(cst, {
    sourceMap
  });
};
exports.parse = parse;