"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HtmlWebpackSkipAssetsPlugin = void 0;
var HtmlWebpackPlugin = require("html-webpack-plugin");
var minimatch = require("minimatch");
var PLUGIN_NAME = 'HtmlSkipAssetsPlugin';
var HtmlWebpackSkipAssetsPlugin = (function () {
    function HtmlWebpackSkipAssetsPlugin(_config) {
        if (_config === void 0) { _config = { skipAssets: [], excludeAssets: [] }; }
        this._config = _config;
    }
    HtmlWebpackSkipAssetsPlugin.prototype.apply = function (compiler) {
        var _this = this;
        if (compiler.hooks) {
            compiler.hooks.compilation.tap(PLUGIN_NAME, function (compilation) {
                if (compilation.hooks.htmlWebpackPluginAlterAssetTags) {
                    compilation.hooks.htmlWebpackPluginAlterAssetTags.tapAsync(PLUGIN_NAME, function (data, cb) {
                        var filters = __spreadArray(__spreadArray(__spreadArray(__spreadArray([], (_this._config.skipAssets || []), true), (_this._config.excludeAssets || []), true), (data.plugin.options.skipAssets || []), true), (data.plugin.options.excludeAssets || []), true);
                        data.head = _this._skipAssets(data.head, filters);
                        data.body = _this._skipAssets(data.body, filters);
                        return cb(null, data);
                    });
                }
                else if (HtmlWebpackPlugin && HtmlWebpackPlugin.getHooks) {
                    var hooks = HtmlWebpackPlugin.getHooks(compilation);
                    hooks.alterAssetTags.tapAsync(PLUGIN_NAME, function (data, cb) {
                        var filters = __spreadArray(__spreadArray(__spreadArray(__spreadArray([], (_this._config.skipAssets || []), true), (_this._config.excludeAssets || []), true), (data.plugin['options'].skipAssets || []), true), (data.plugin['options'].excludeAssets || []), true);
                        data.assetTags.scripts = _this._skipAssets(data.assetTags.scripts, filters);
                        data.assetTags.styles = _this._skipAssets(data.assetTags.styles, filters);
                        data.assetTags.meta = _this._skipAssets(data.assetTags.meta, filters);
                        return cb(null, data);
                    });
                }
                else {
                    throw new Error('Cannot find appropriate compilation hook');
                }
            });
        }
        else {
            compiler.plugin('compilation', function (compilation) {
                compilation.plugin('html-webpack-plugin-alter-asset-tags', function (htmlPluginData, callback) {
                    var filters = __spreadArray(__spreadArray(__spreadArray(__spreadArray([], (_this._config.skipAssets || []), true), (_this._config.excludeAssets || []), true), (htmlPluginData.plugin.options.skipAssets || []), true), (htmlPluginData.plugin.options.excludeAssets || []), true);
                    htmlPluginData.head = _this._skipAssets(htmlPluginData.head, filters);
                    htmlPluginData.body = _this._skipAssets(htmlPluginData.body, filters);
                    return callback(null, htmlPluginData);
                });
            });
        }
    };
    HtmlWebpackSkipAssetsPlugin.prototype._skipAssets = function (assets, matchers) {
        return assets.filter(function (a) {
            var skipped = matchers.some(function (matcher) {
                var _a, _b;
                if (!matcher) {
                    return false;
                }
                var assetUrl = ((_b = (_a = a.attributes.src) !== null && _a !== void 0 ? _a : a.attributes.href) !== null && _b !== void 0 ? _b : '');
                if (typeof matcher === 'string') {
                    return minimatch(assetUrl, matcher);
                }
                if (matcher.constructor && matcher.constructor.name === 'RegExp') {
                    var regexMatcher = matcher;
                    return !!(assetUrl.match(regexMatcher));
                }
                if (typeof matcher === 'function') {
                    var matchesCallback = matcher(a);
                    return !!(matchesCallback);
                }
                return false;
            });
            return !skipped;
        });
    };
    return HtmlWebpackSkipAssetsPlugin;
}());
exports.HtmlWebpackSkipAssetsPlugin = HtmlWebpackSkipAssetsPlugin;
//# sourceMappingURL=plugin.js.map