"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ArrayMergeOperations = [
    "combine",
    "replace",
    "concat",
];
class Config {
    constructor(config) {
        this.set(config);
    }
    set(config) {
        config = config || {};
        this.cwd = typeof config.cwd === "string" ? config.cwd : "";
        this.errorOnFileNotFound = config.errorOnFileNotFound !== false;
        this.errorOnRefNotFound = config.errorOnRefNotFound !== false;
        this.enableExpressionOperation = config.enableExpressionOperation === true;
        this.operationPrefix =
            typeof config.operationPrefix === "string" ? config.operationPrefix : "$";
        this.params = config.params;
        this.stringify =
            config.stringify === true || config.stringify === "pretty"
                ? config.stringify
                : false;
        this.defaultArrayMergeOperation =
            ArrayMergeOperations.indexOf(config.defaultArrayMergeOperation) !== -1
                ? config.defaultArrayMergeOperation
                : "combine";
        this.spaces = config.spaces;
    }
}
exports.default = Config;
//# sourceMappingURL=Config.js.map