"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class DataDeserializer {
    constructor() {
        this._deserializers = [];
    }
    deserialize(uri, content) {
        const deserializer = this._deserializers.filter((x) => x.match(uri))[0];
        if (!deserializer) {
            throw new Error(`No deserializer found for file "${uri}"`);
        }
        return deserializer.deserialize(uri, content);
    }
    addDeserializer(deserializer) {
        this._deserializers.push(deserializer);
    }
    addDeserializers(deserializers) {
        deserializers.forEach((deserializer) => this.addDeserializer(deserializer));
    }
}
exports.default = DataDeserializer;
//# sourceMappingURL=DataDeserializer.js.map