"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Operation_1 = __importDefault(require("./Operation"));
class AfterMergeOperation extends Operation_1.default {
    name() {
        return "afterMerge";
    }
    processInObject(keyword, source, target) {
        if (this._processor.currentScope.phase !== "afterMerge") {
            this._processor.currentScope.registerPhase("afterMerge");
            return source;
        }
        const keywordValue = source[keyword];
        return this._processor.processSource(keywordValue, target);
    }
}
exports.default = AfterMergeOperation;
//# sourceMappingURL=AfterMergeOperation.js.map