"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Operation_1 = __importDefault(require("./Operation"));
class IncludeOperation extends Operation_1.default {
    name() {
        return "include";
    }
    processInObject(keyword, source, target) {
        const keywordValue = source[keyword];
        const result = this._processor.loadFileByRef(keywordValue);
        return this._processor.processSource(result, target);
    }
    processInArray(keyword, source, sourceArray, sourceArrayIndex, resultArray, resultArrayIndex, target) {
        const keywordValue = source[keyword];
        const content = this._processor.loadFileByRef(keywordValue);
        return this._processor.processArrayItem(content, sourceArray, sourceArrayIndex, resultArray, resultArrayIndex, target);
    }
}
exports.default = IncludeOperation;
//# sourceMappingURL=IncludeOperation.js.map