"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Operation_1 = __importDefault(require("./Operation"));
class InsertOperation extends Operation_1.default {
    name() {
        return "insert";
    }
    processInArray(keyword, source, _sourceArray, _sourceArrayIndex, resultArray, resultArrayIndex, _target) {
        const keywordValue = source[keyword];
        const item = this._processor.processSourceProperty(keywordValue.value, "value");
        const index = keywordValue.index === "-" ? resultArray.length : keywordValue.index;
        resultArray.splice(index, 0, item);
        resultArrayIndex =
            index <= resultArrayIndex ? resultArrayIndex + 1 : resultArrayIndex;
        return { resultArray, resultArrayIndex };
    }
}
exports.default = InsertOperation;
//# sourceMappingURL=InsertOperation.js.map