import webpack_stats = require('./webpack_stats');
/** A node in the package size tree
  */
export interface StatsNode {
    /** Name of the package. ie. 'foo' from 'node_modules/foo' */
    packageName: string;
    /** Total size of files in this package, including its dependencies,
      * in bytes.
      */
    size: number;
    children: StatsNode[];
}
export interface RootStatsNode extends StatsNode {
    bundleName?: string;
}
/** Walk a dependency size tree produced by dependencySizeTree() and output the
  * size contributed to the bundle by each package's own code plus those
  * of its dependencies.
  */
export declare function printDependencySizeTree(node: StatsNode, shareStats: boolean, depth?: number, outputFn?: (str: string) => void): void;
/** Takes the output of 'webpack --json', and returns
  * an array of trees of require()'d package names and sizes.
  *
  * There is one entry in the array for each bundle specified
  * in the Webpack compilation.
  */
export declare function dependencySizeTree(stats: webpack_stats.WebpackStats): RootStatsNode[];
