#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lib_1 = require("../lib");
const args_1 = require("./lib/args");
const main = () => Promise.resolve()
    // Parse arguments.
    .then(args_1.parse)
    // Create action.
    .then(({ action, format, stats, ignoredPackages, bail }) => lib_1.actions(action, { stats, ignoredPackages }).then((instance) => 
// Render, report, and bail if configured.
instance.template.render(format)
    .then((out) => {
    // Report.
    console.log(out); // tslint:disable-line no-console
    // Don't bother checking if we aren't going to bail.
    if (!bail) {
        return Promise.resolve();
    }
    // Check and bail if appropriate.
    return instance.shouldBail().then((shouldBail) => {
        if (shouldBail) {
            throw new Error(`Issues found in action: ${action}`);
        }
    });
})))
    .catch((err) => {
    // Try to get full stack, then full string if not.
    console.error(err.stack || err.toString()); // tslint:disable-line no-console
    process.exit(1);
});
if (require.main === module) {
    main();
}
