"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parse = void 0;
const yargs = require("yargs");
const lib_1 = require("../../lib");
// Validate and normalize.
const validate = (parser) => {
    const { argv } = parser;
    const { action, format, ignoredPackages, bail } = argv;
    // Defaults
    const statsFile = argv.stats;
    return lib_1.readJson(statsFile).then((stats) => ({
        action,
        format,
        ignoredPackages,
        stats,
        bail,
    }));
};
const args = () => yargs
    .usage(`Usage: inspectpack -s <file> -a <action> [options]`)
    // Actions
    .option("action", {
    alias: "a",
    choices: Object.keys(lib_1.ACTIONS),
    describe: "Actions to take",
    required: true,
    type: "string",
})
    .example("inspectpack -s stats.json -a duplicates", "Show duplicates files")
    .example("inspectpack -s stats.json -a versions", "Show version skews in a project")
    .example("inspectpack -s stats.json -a sizes", "Show raw file sizes")
    // Files
    .option("stats", {
    alias: "s",
    describe: "Path to webpack-created stats JSON object",
    required: true,
    type: "string",
})
    // Display
    .option("format", {
    alias: "f",
    choices: Object.keys(lib_1.TemplateFormat),
    default: lib_1.TemplateFormat.text,
    describe: "Display output format",
    type: "string",
})
    // Ignores
    .option("ignored-packages", {
    alias: "i",
    default: [],
    describe: "List of package names (space separated) to ignore",
    type: "array",
})
    // Ignores
    .option("bail", {
    alias: "b",
    default: false,
    describe: "Exit non-zero if duplicates/versions results found",
    type: "boolean",
})
    // Logistical
    .help().alias("help", "h")
    .version().alias("version", "v")
    .strict();
const parse = () => validate(args());
exports.parse = parse;
