import { IAction, IActionConstructor, TemplateFormat } from "./actions/base";
import { IWebpackStats } from "./interfaces/webpack-stats";
interface IActions {
    [key: string]: (opts: IActionConstructor) => IAction;
}
export declare const ACTIONS: IActions;
export interface IRenderOptions extends IActionConstructor {
    action: "duplicates" | "sizes" | "versions";
    format: TemplateFormat;
    stats: IWebpackStats;
    ignoredPackages: (string | RegExp)[];
}
/**
 * Get action instance.
 *
 * @param name {String} name of action
 * @param opts {Object} action options
 * @param opts.stats {Object} webpack stats object
 * @returns {Promise<IAction>} action instance
 */
export declare const actions: (name: string, opts: IActionConstructor) => Promise<IAction>;
/**
 * Render action to final template format.
 *
 * @param opts {IRenderOpts} action + render options
 * @param opts.action {String} name of action
 * @param opts.format {Object} output format
 * @param opts.stats {Object} webpack stats object
 * @returns {Promise<string>} Rendered result
 */
export declare const render: ({ action, format, stats, ignoredPackages }: IRenderOptions) => Promise<string>;
export {};
