"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toPosixPath = exports.exists = exports.readDir = exports.readJson = void 0;
const fs_1 = require("fs");
const pify = require("pify");
const readFileP = pify(fs_1.readFile);
const readdirP = pify(fs_1.readdir);
const statP = pify(fs_1.stat);
// Read a file and parse into JSON.
const readJson = (file) => Promise.resolve()
    .then(() => readFileP(file))
    .then((buf) => buf.toString("utf8"))
    .then((str) => JSON.parse(str));
exports.readJson = readJson;
// Permissively read directories, returning empty list of files if not.
const readDir = (path) => Promise.resolve()
    .then(() => readdirP(path))
    // Remove dotfiles.
    .then((files) => files.filter((n) => !n.startsWith(".")))
    .catch((err) => {
    if (err.code === "ENOENT") {
        return [];
    } // Not found.
    throw err; // Rethrow real error.
});
exports.readDir = readDir;
const exists = (filePath) => Promise.resolve()
    .then(() => statP(filePath))
    .then(() => true)
    .catch((err) => {
    if (err.code === "ENOENT") {
        return false;
    } // Not found.
    throw err; // Rethrow real error.
});
exports.exists = exists;
// Convert windows paths to mac/linux.
const toPosixPath = (name) => name.split("\\").join("/");
exports.toPosixPath = toPosixPath;
