"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class DataLoader {
    constructor(_config, _dataDeserializer, _fileLoader) {
        this._config = _config;
        this._dataDeserializer = _dataDeserializer;
        this._fileLoader = _fileLoader;
        this._cache = {};
    }
    load(uri, currentUri) {
        const absoluteUri = this.toAbsoluteUri(uri, currentUri);
        if (this._cache[absoluteUri]) {
            return this._cache[absoluteUri];
        }
        let content;
        try {
            content = this._fileLoader.load(uri, currentUri);
        }
        catch (e) {
            if (this._config.errorOnFileNotFound) {
                throw new Error(`The file "${uri}" does not exist. Set Config.errorOnFileNotFound to false to suppress this message`);
            }
            return;
        }
        let result;
        if (content !== undefined) {
            result = this._dataDeserializer.deserialize(uri, content);
        }
        this._cache[absoluteUri] = result;
        return result;
    }
    toAbsoluteUri(uri, currentUri) {
        return this._fileLoader.toAbsoluteUri(uri, currentUri);
    }
    clearCache() {
        this._cache = {};
        this._fileLoader.clearCache();
    }
}
exports.default = DataLoader;
//# sourceMappingURL=DataLoader.js.map