"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const json_ptr_1 = require("json-ptr");
const Scope_1 = require("./Scope");
class MergerError extends Error {
    constructor(originalError, scope) {
        super();
        this.__proto__ = MergerError.prototype;
        const message = this._createMessage(scope);
        const stack = this._createProcessingStackTrace(scope);
        this.name = "MergerError";
        this.message = `${message}${stack}\n${originalError.message}`;
        this.stack = `${message}${stack}\n${originalError.stack}`;
    }
    _createMessage(scope) {
        let message = "";
        if (scope) {
            const lastProp = scope.propertyPath[scope.propertyPath.length - 1];
            message = `An error occurred while processing the property "${lastProp}"\n`;
        }
        return message;
    }
    _createProcessingStackTrace(scope) {
        let trace = "";
        let currentScope = scope;
        while (currentScope && !(currentScope instanceof Scope_1.GlobalScope)) {
            const pathEncoded = (0, json_ptr_1.encodePointer)(currentScope.propertyPath);
            let filePath = "";
            if (currentScope instanceof Scope_1.MergeFileScope ||
                currentScope instanceof Scope_1.RootMergeFileScope) {
                filePath = currentScope.sourceFilePath;
            }
            trace += `    at ${filePath}#${pathEncoded}\n`;
            currentScope = currentScope.parent;
        }
        return trace;
    }
}
exports.default = MergerError;
//# sourceMappingURL=MergerError.js.map