"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class DataSerializer {
    constructor() {
        this._serializers = [];
    }
    serialize(uri, data, pretty, spaces) {
        const serializer = this._serializers.filter((x) => x.match(uri))[0];
        if (!serializer) {
            throw new Error(`No serializer found for file "${uri}"`);
        }
        return serializer.serialize(uri, data, pretty, spaces);
    }
    addSerializer(serializer) {
        this._serializers.push(serializer);
    }
    addSerializers(serializers) {
        serializers.forEach((serializer) => this.addSerializer(serializer));
    }
}
exports.default = DataSerializer;
//# sourceMappingURL=DataSerializer.js.map