"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class FileLoader {
    constructor() {
        this._uriCache = {};
        this._loaders = [];
    }
    load(uri, currentUri) {
        const loader = this._loaders.filter((x) => x.loader.match(uri, currentUri))[0];
        if (loader === undefined) {
            throw new Error(`No file loader found for file "${uri}"`);
        }
        const absoluteUri = loader.loader.toAbsoluteUri(uri, currentUri);
        return loader.loader.load(absoluteUri);
    }
    addLoader(loader, priority) {
        this._loaders.push({ loader, priority });
        this._loaders = this._loaders.sort((a, b) => -(a.priority - b.priority));
    }
    addLoaders(loaders) {
        loaders.forEach((x) => this.addLoader(x[0], x[1]));
    }
    toAbsoluteUri(uri, currentUri) {
        const cacheKey = uri + currentUri;
        if (this._uriCache[cacheKey]) {
            return this._uriCache[cacheKey];
        }
        const loader = this._loaders.filter((x) => x.loader.match(uri, currentUri))[0];
        if (!loader) {
            return;
        }
        const absoluteUri = loader.loader.toAbsoluteUri(uri, currentUri);
        this._uriCache[cacheKey] = absoluteUri;
        return absoluteUri;
    }
    clearCache() {
        this._uriCache = {};
    }
}
exports.default = FileLoader;
//# sourceMappingURL=FileLoader.js.map