"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Operation_1 = __importDefault(require("./Operation"));
class MoveOperation extends Operation_1.default {
    name() {
        return "move";
    }
    processInArray(keyword, source, _sourceArray, _sourceArrayIndex, resultArray, resultArrayIndex, _target) {
        const keywordValue = source[keyword];
        let item = resultArray.splice(resultArrayIndex, 1)[0];
        resultArrayIndex--;
        let index;
        if (typeof keywordValue === "number" || keywordValue === "-") {
            index = keywordValue;
        }
        else {
            index = keywordValue.index;
            if (keywordValue.value !== undefined) {
                item = this._processor.processSourceProperty(keywordValue.value, "value", item);
            }
        }
        if (index === "-") {
            index = resultArray.length;
        }
        resultArray.splice(index, 0, item);
        resultArrayIndex =
            index <= resultArrayIndex ? resultArrayIndex + 1 : resultArrayIndex;
        return { resultArray, resultArrayIndex };
    }
}
exports.default = MoveOperation;
//# sourceMappingURL=MoveOperation.js.map