"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Operation_1 = __importDefault(require("./Operation"));
class RemoveOperation extends Operation_1.default {
    name() {
        return "remove";
    }
    processInObject(keyword, source, target) {
        const keywordValue = source[keyword];
        if (keywordValue === true) {
            return undefined;
        }
        return target;
    }
    processInArray(keyword, source, _sourceArray, _sourceArrayIndex, resultArray, resultArrayIndex, _target) {
        const keywordValue = source[keyword];
        if (keywordValue === true) {
            resultArray.splice(resultArrayIndex, 1);
            resultArrayIndex--;
        }
        return { resultArray, resultArrayIndex };
    }
}
exports.default = RemoveOperation;
//# sourceMappingURL=RemoveOperation.js.map