"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Operation_1 = __importDefault(require("./Operation"));
const Scope_1 = require("../Scope");
class SelectOperation extends Operation_1.default {
    name() {
        return "select";
    }
    processInObject(keyword, source, target) {
        const keywordValue = source[keyword];
        let value;
        let selectContext;
        const scope = this._processor.currentScope;
        if (scope instanceof Scope_1.RootMergeFileScope ||
            scope instanceof Scope_1.RootMergeObjectScope) {
            selectContext = scope.source;
        }
        else {
            selectContext = scope.root;
        }
        if (typeof keywordValue === "string") {
            value = this._processor.resolveJsonPointer(selectContext, keywordValue);
        }
        else {
            if (keywordValue.from !== undefined) {
                selectContext = this._processor.processSourceProperty(keywordValue.from, "from");
            }
            if (typeof keywordValue.path === "string") {
                value = this._processor.resolveJsonPointer(selectContext, keywordValue.path);
            }
            else if (typeof keywordValue.query === "string") {
                value = this._processor.resolveJsonPath(selectContext, keywordValue.query);
                if (keywordValue.multiple !== true) {
                    value = value[0];
                }
            }
        }
        return this._processor.processSource(value, target);
    }
}
exports.default = SelectOperation;
//# sourceMappingURL=SelectOperation.js.map