export declare type Milliseconds = number;
export declare type Bytes = number;
export declare type Path = string;
export interface WebpackAsset {
    name: string;
    size: Bytes;
    chunks: number[];
    chunkNames: string[];
    emitted: boolean;
}
export interface WebpackChunk {
}
export interface WebpackModule {
    id: number;
    identifier: Path;
    name: string;
    size: Bytes;
}
export interface CompilationBase {
    name?: string;
    errors: any[];
    hash: string;
    version: string;
    warnings: any[];
}
/** JSON structure produced when Webpack config
  * is an array of bundles.
  */
export interface WebpackMultiCompilation extends CompilationBase {
    children: WebpackCompilation[];
}
/** JSON structure produced for a single bundle generated by
  * a Webpack compilation.
  */
export interface WebpackCompilation extends CompilationBase {
    time: Milliseconds;
    assetsByChunkName: {
        [chunkName: string]: string;
    };
    assets: WebpackAsset[];
    chunks: WebpackChunk[];
    modules: WebpackModule[];
}
/** JSON structure of `webpack --json` output */
export declare type WebpackStats = WebpackMultiCompilation | WebpackCompilation;
export declare function isMultiCompilation(stats: WebpackStats): stats is WebpackMultiCompilation;
